#!/usr/local/bin/perl
#print "Content-Type: text/html;\n\n"

##!d:/perl/bin/perl.exe

# Written by Rendall Internet Service Enterprises (rise@rendall.com)
# April, 1999
#
# This program is called from catalog.html.
# A parameter is sent to indicate the name of the file we wish to display.

push(@INC,"/cgi-bin");

use lib '.';
require("catalog.txt");
use CGI qw(:standard :cgi-lib escapeHTML); # Added escapeHTML for HTML escaping

print "Content-type: text/html\n\n";

# get filename
my $q = CGI->new;
$type = $q->param('keywords');

# if no number on filename, add 1
if ($type !~ /-/) {
    $type .= "-1";
}

$type2 = $type;
$file = "filz/$type2.vvm";

# drop number from filename
($type, undef) = split("-", $type);

# blank out the condition statement for selected categories
if ($NOCOND{$type}) {
    $COND_STATEMENT = "";
}

SetNavBar();

# open the requested file
open (LIST, "$file") or die "$file - Could not display requested records - please try again later.";   
# print the records & bail

&PrintHdr;
&PrintRecs;
&PrintFtr;

exit;

########################
# SUBROUTINES
########################

sub PrintHdr {
    print <<ENDHEADER;
<HTML>
<HEAD>
        <TITLE>VVMO Catalog</TITLE>
</HEAD>

<BODY BACKGROUND="/back.gif" BGCOLOR="#FF99CC" TEXT="#000000" LINK="#8000FF" VLINK="#CC0066" ALINK="#FF0000">
<BASEFONT SIZE="3" FACE="arial,helvetica">
<CENTER>
<IMG SRC="/vvmo.gif" WIDTH=268 HEIGHT=95 BORDER=0 HSPACE=4 VSPACE=8 ALT="VVMO"><BR><BR>

<FONT SIZE="+2"><B>$TITLES{$type}</FONT>

$MESSAGE{$type}
$COND_STATEMENT
$NAVBAR

<P>
<B><em>$INSTRUCTIONS</em></b>
<P>
<FORM METHOD='POST' ACTION='/cgi-bin/shopcart.pl'>

<TABLE BORDER CELLSPACING=1 CELLPADDING=4>
ENDHEADER
}

########################

sub PrintRecs {
    local($line, $value);
    $num = 0;
    while (<LIST>) {
        $num++;
        chop;
        $line = $_;

        if (length($line) < 2) {
            next; # skip blank lines
        }

        # skip the first 3 fields (recent, category, date)
        $line =~ s/^[^\t]*\t[^\t]*\t[^\t]*\t//;

        if ($num == 1) {
            $line = "ADD\t" . $line;
            $line =~ s|\t|</font></b></td>\n<TD ALIGN=MIDDLE><B><FONT SIZE=2 COLOR=\"#CC0066\">|g;
            print "<TR>\n<TD ALIGN=MIDDLE><B><FONT SIZE=2 COLOR=\"#CC0066\">$line</font></b></td>\n</tr>\n";
        } else {
            # add category to beginning of line
            $value = "$type~~$line";
            $value =~ s|\t|~~|g;
            $value =~ s/\"/\'/g;

            # Escape the display fields only
            my @fields = split /\t/, $line;
            my $format = escapeHTML($fields[0]);
            my $artist = escapeHTML($fields[1]);
            my $title = escapeHTML($fields[2]);
            my $details = escapeHTML($fields[3]);
            my $price = $fields[4];  # Unescaped

            # Reconstruct the line for display
            $line = join("\t", $format, $artist, $title, $details, $price);
            $line =~ s|\t|</font></b></td>\n<TD><B><FONT SIZE=2>|g;

            print "<TR>\n<TD align=middle><input TYPE='checkbox' NAME='box$num' VALUE=\"$value\"></td><TD><B><FONT SIZE=2>$line</font></b></td>\n</tr>\n";
        }
    }
}

########################

sub PrintFtr {
    print <<ENDFOOTER;
</TABLE>
<P>
$NAVBAR
<P>
<a href="#top">Back to Top</a>
<P>
<INPUT TYPE='submit' VALUE='Add to Cart/Checkout'>
</form>

</b>
</font>

<P>

| 
<A HREF="/welcome.html"><B>Home</B></A> | 
<A HREF="/search.html"><B>Search</B></A> |
<A HREF="/cgi-bin/catalog.pl?recarr"><B>Recent Arrivals</B></A> | 
<A HREF="/catalog.html"><B>Catalog</B></A> | 
<A HREF="/about-us.html"><B>About Us</B></A> | 
<A HREF="/helpful-hints.html"><B>Helpful Hints</B></A> | 
<A HREF="/links.html"><B>Links</B></A> | 

</center>
<P>

<TABLE width=100%>
<TR><TD align=right><font size=2>$num</font></TD></TR>
</table>

</BODY>
</HTML>
ENDFOOTER
}

########################

sub SetNavBar {
    if (! open (INI, "filz/$type.ini")) {
        print "Sorry, this file is not available at this time ($type).";
        exit;
    }

    $NAVBAR = "<P>|";
    while (<INI>) {
        chomp;
        ($linkFile, $linkDesc) = split("\t");

        # make the current file bold text with no link
        if ($linkFile eq $type2) {
            $NAVBAR .= " <font size=+1><B>$linkDesc</b></font> | ";
        } else {
            $NAVBAR .= "<a href=\"/cgi-bin/catalog.pl?$linkFile\">$linkDesc</a> | ";
        }
    }

    # add extra stuff to end, if there is anything
    $NAVBAR .= "<B>$EXTRALINK{$type}</b>";
}