#!/usr/local/bin/perl

##!d:/perl/bin/perl.exe

# (c) 2000-2002 Rendall Internet Service Enterprises (rise@rendall.com)
#
# This program is called from gen/index.html to split out all the individual category files

#########################
$maxcount = 200;	# this is the maximun number of records to display per page
#########################
$numletters = 4;	# this is the number of letters to include in the links
#########################


push(@INC,"/cgi-bin");


print "Content-type: text/html\n\n";

print "<font size=6><P align=CENTER>VVMO: THE GENERATOR</font><P>";


if (!open(TEXT, "<new/stock.txt")) 
	{
	print "Could not open main file: stock.txt!!";
	exit;
	}

@newArray;
$recs = 0;
$cat = "";
$prevCat = "";
$count = 0;

while (<TEXT>)
	{
	$recs++;
	if ($recs == 1)
		{
		# this is the heading line - save it, then skip it
		$heading = $_;
		next;
		}

	$rec = $_;
	$xx = "";
	
	# get "new" status & category
	($new,$cat,undef) = split('\t', $rec, 3);
	$cat = lc($cat);

	# add all the new records to an array, then continue
	if ($new == 1)
		{
		# add the artist & title to the beginning of the rec
		($undef,$undef,$undef,$undef,$art,$ttl,$undef) = split(/\t/, $rec, 7);
		$temprec = $art . $ttl . "```~~~" . $rec;
		push @newArray, $temprec;
		}
	elsif ($rec !~ m/^0/)	# bad or blank record
		{next;}

	if ($cat ne $prevCat)
		{
		# the category has changed:
		# finish off this one (if it's not the first actual record)...
		if ($recs > 2)
			{
			WriteINI();
			close INI;
			}

		# ... and start the next one
		$filecount = 1;
		$filename = $cat . "-$filecount";

		print "<P><font size=4>--------------------------------------------------<BR>$cat<BR>--------------------------------------------------</font><BR>";

		# create a new ini file for this category
		open(INI, ">filz/$cat.ini") or die "Couldn't create INI file: $!";

		# delete all previous files for this category
		print "<B>DELETING OLD FILES:</b>";
		opendir(THISDIR, "filz") or die "Couldn't open new files directory: $!";
		@files = readdir THISDIR;
		closedir THISDIR;

		foreach (@files)
			{
			if (m/^$cat-/)
				{
				$names="filz/" . $_;
				print "<BR>...$_";
				unlink($names);
				}
			}


		print "<P><B>CREATING NEW FILES:</b>";

		$count = 0;
		$end = "";
		$prevCat = $cat;
		}
	
	#####################
	# PROCESS EACH RECORD
	#####################

	$count++;
	if ($count > $maxcount)
		{
		# only end this file when the current group has changed
		# see if the starting letters of this rec have changed from the previous rec
		($undef,$undef,$undef,$undef,$xx) = split(/\t/, $rec);
		$xx = substr($xx,0,$numletters);	# get 1st x letters of this record
		
		if ($xx ne $end)
			{
			WriteINI();
			$filecount++;
			$filename = $cat . "-$filecount";
			$count = 1;
			$end = $xx;
			}
		}

	if ($count == 1)
		{
		open(NEWFILE, ">filz/$filename.vvm") or die "Couldn't create new file: $!";
		print NEWFILE $heading;	# start file with heading record

		($undef,$undef,$undef,$undef,$beg) = split(/\t/, $rec);
		$beg = substr($beg,0,$numletters);	# get 1st x letters of this record
		}

	print NEWFILE $rec;

	# save the current group name
	($undef,$undef,$undef,$undef,$end) = split(/\t/, $rec);
	$end = substr($end,0,$numletters);	# get 1st x letters of this record

	}	# end of "while (<TEXT>)"


close TEXT;
WriteINI();
close INI;

###################################
# now create file(s) for newrecords
###################################

# note: for recent arrivals, we index on the category name, rather than the artist name

# first sort the array by artist & title (which is at the beginning of each record
@arrayNew = sort(@newArray);

$first = 1;
foreach $rec (@arrayNew)
	{
	# drop the sorting keys at the beginning of each rec
	($undef, $rec) = split(/```~~~/, $rec);

	$xx = "";
		
	if ($first)
		{
		$first = 0;
		$filecount = 1;
		$filename = "recarr" . "-$filecount";

		print "<P><font size=4>--------------------------------------------------<BR>Recent Arrivals<BR>--------------------------------------------------</font><BR>";

		# create a new ini file for this category
		open(INI, ">filz/recarr.ini") or die "Couldn't create INI file: $!";

		# delete all previous files for this category
		print "<B>DELETING OLD FILES:</b>";
		opendir(THISDIR, "filz") or die "Couldn't open new files directory: $!";
		@files = readdir THISDIR;
		closedir THISDIR;

		foreach (@files)
			{
			if (m/^recarr-/)
				{
				$names="filz/" . $_;
				print "<BR>...$_";
				unlink($names);
				}
			}


		print "<P><B>CREATING NEW FILES:</b>";

		$count = 0;
		$end = "";
		}
	
	###########################
	# PROCESS EACH "NEW" RECORD
	###########################

	$count++;
	if ($count > $maxcount)
		{
		# see if the starting letters of this rec have changed from the previous rec
		($undef,$undef,$undef,$undef,$xx) = split(/\t/, $rec);
		$xx = substr($xx,0,$numletters);	# get 1st x letters of this record
		
		if ($xx ne $end)
			{
			WriteINI();
			$filecount++;
			$filename = "recarr" . "-$filecount";
			$count = 1;
			$beg = $xx;
			$end = $xx;
			$xx = "*DONE*";
			}
		}

	if ($count == 1)
		{
		open(NEWFILE, ">filz/$filename.vvm") or die "Couldn't create new file: $!";
		print NEWFILE $heading;	# start file with heading record

		if ($xx ne "*DONE*")
			{
			($undef,$undef,$undef,$undef,$beg) = split(/\t/, $rec);
			$beg = substr($beg,0,$numletters);	# get 1st x letters of this record
			$end = $beg;
			}
		}
		
	else
		{
		# save the current group name
		($undef,$undef,$undef,$undef,$end) = split(/\t/, $rec);
		$end = substr($end,0,$numletters);	# get 1st x letters of this record
		}

	print NEWFILE $rec;

	} # foreach

WriteINI();
close INI;

$recs--;
print "<P><B>DONE with $recs records!</b>";
exit;


#################################################################
sub DebugPrint
{
	print "$_[0]"; 
	exit;
}



#################################################################
sub WriteINI
{
	close(NEWFILE);
	print "<BR>...$filename.vvm";
	print INI "$filename\t$beg-$end\n";
}



