#!/usr/local/bin/perl

use strict;
use warnings;
use CGI qw(:standard :cgi-lib); # <--- MODIFIED
use Net::SMTP;

# REMOVE OR COMMENT OUT THIS LINE: push(@INC, "/cgi-bin");
use lib '.'; # <--- ADDED

# REMOVE OR COMMENT OUT THIS LINE: require("cgi-lib.pl");

&ReadParse; # This function is provided by CGI.pm when using :cgi-lib

# Set SendGrid SMTP server configuration
my $SENDGRID_HOST = 'smtp.sendgrid.net';
my $SENDGRID_PORT = 587;
my $SENDGRID_USERNAME = 'apikey';
my $SENDGRID_PASSWORD = '<secret>'; # <<< SECURITY RISK - FIX ASAP!

sub handle_error {
    my ($error_message) = @_;
    print header;
    print <<ENDERROR;
<HTML>
<HEAD><TITLE>VVMO - Ordering Error</TITLE></HEAD>
<BODY BACKGROUND="/back.gif">
<CENTER>
<IMG SRC="/vvmo.gif" WIDTH=268 HEIGHT=95 BORDER=0 HSPACE=4 VSPACE=8 ALT="VVMO"><BR><BR>
<font size=5><B>Error in Order Form</b></font>
<P>
<font size=4>Your order was not sent due to the following error...</font>
<P>
<HR>
<P>
<BLOCKQUOTE>
<STRONG>Error:</STRONG> <font size=5>$error_message</font>
<P>
<P>
<B>Please return to the order form (by pressing the "Back" button) and correct the issue before resubmitting your form.<BR>
Thank you!</b>
</BLOCKQUOTE>
<P>
</BODY>
</HTML>
ENDERROR
    exit;
}

# Immediately check the email address to reject if from example.com
my $from = $in{"required-email"};

# Check if the email ends with @example.com
if ($from =~ /\@example\.com$/i) {
    # Log that this email was rejected
    open my $debug_log, '>>', 'cgi-bin/debug_log.log' or die "Could not open debug log file: $!";
    print $debug_log "Rejected email from @example.com: $from\n";
    close $debug_log;
    
    # Exit and reject the form silently
    print header;
    print "Thank you! Your order has been rejected because email addresses from @example.com are not allowed.\n";
    exit;
}

# Proceed with the rest of the order handling...
foreach my $field_name (qw(required-name required-email required-address)) {
    if (!$in{$field_name}) {
        handle_error("Required field missing: $field_name");
    }
}

# If email passes the check, continue with SendGrid processing
print STDERR "Attempting to connect to SendGrid SMTP server...\n";
my $smtp = Net::SMTP->new(
    $SENDGRID_HOST,
    Port    => $SENDGRID_PORT,
    Timeout => 30,
    Debug   => 1,  # Enable debug mode
) or handle_error("Failed to connect to SendGrid's SMTP server: $!");

print STDERR "Attempting to authenticate...\n";
$smtp->auth($SENDGRID_USERNAME, $SENDGRID_PASSWORD) or handle_error("SMTP authentication failed: $!");

print STDERR "Sending email...\n";

# Send email to VVMO
$smtp->mail($from);
$smtp->recipient('mail@vvmo.com');

my $subject = 'VVMO Order';
my $message = "Name: $in{\"required-name\"}\nEmail: $from\nAddress:\n$in{\"required-address\"}\n\n";

$smtp->data();
$smtp->datasend("To: mail@vvmo.com\n");
$smtp->datasend("From: $from\n");
$smtp->datasend("Subject: $subject\n");
$smtp->datasend("Content-Type: text/plain; charset=UTF-8\n");
$smtp->datasend("\n$message");
$smtp->dataend();

# Send confirmation email to customer
my $customer_subject = 'Your VVMO Order Confirmation';
my $customer_message = "Thank you for your order!\n\nName: $in{\"required-name\"}\nEmail: $from\nAddress:\n$in{\"required-address\"}\n\n";

$smtp->mail('mail@vvmo.com');
$smtp->recipient($from);

$smtp->data();
$smtp->datasend("To: $from\n");
$smtp->datasend("From: mail@vvmo.com\n");
$smtp->datasend("Subject: $customer_subject\n");
$smtp->datasend("Content-Type: text/plain; charset=UTF-8\n");
$smtp->datasend("\n$customer_message");
$smtp->dataend();

$smtp->quit();

print STDERR "Email sent successfully.\n";

sub sanitize_output {
    my ($text) = @_;
    $text =~ s/<[^>]*>//g;  # Remove HTML tags
    $text =~ s/&/&amp;/g;
    $text =~ s/</&lt;/g>;
    $text =~ s/>/&gt;/g;
    return $text;
}

@items = split(/\|\|\|/, $in{order});
foreach (@items) {
    print sanitize_output($_) . "\n";
}
