#!/usr/local/bin/perl # Consider changing to #!/usr/bin/perl if the old one is bad

# Written by Rendall Internet Service Enterprises (rise@rendall.com)
# Dec, 2000
#
# This program is called from search.html.

# REMOVE OR COMMENT OUT THIS LINE: push(@INC,"/cgi-bin");

use lib '.'; # <-- ADD THIS LINE

#--LEAVE COMMENTED
#require("cgi-lib.pl");
#--END LEAVE COMMENTED
require("catalog.txt"); # <--- This should now be found

use CGI qw(:standard); # This is good, no change needed here based on current errors


print "Content-type: text/html\n\n";

PrintHdr();


my($fields) = new CGI;	# this gets all the form fields

# get the search term
$theSearch = uc($fields->param("findthis"));
$theSearch =~ s/\+/\\+/g;

# exact match?
$exactMatch = uc($fields->param("exact"));

# any terms to exclude?
$exclude = uc($fields->param("exclude"));
if ($exclude ne '')
	{@exclusions = split(/ /, $exclude);}

#--LEAVE COMMENTED
#if ($theSearch =~ /^"/)
#	{
#	# exact match
#	$theSearch =~ s/"//g;
#	@searches = $theSearch;
#	}
#else
#--END LEAVE COMMENTED

# split it into its components, if there are any
@searches = split(/\|/, $theSearch);

#--LEAVE COMMENTED
#@cats;
#--END LEAVE COMMENTED

@searchFiles;

#--LEAVE COMMENTED
#if ($fields->param("files") eq "*sel*")
#	{
	# we only want files from selected categories, 
	# so make an array of the ones we want
	
	# loop thru all passed-in fields
#	foreach ($fields->param)
#		{
		# a fieldname beginning with "x-" is a selected category
#		if ($_ =~ s/^x-//)
#			{push @cats, $_;}
#		}
#	}
#--END LEAVE COMMENTED


print "<br />";

$totalhits = 0;

# loop thru all the files in the directory
opendir(DIR, "filz") or die "Can't do this, sorry! ($!)";
while(defined($file = readdir(DIR)))
	{
	if ($file =~ /.vvm/)
		{
		push @searchFiles, $file;
		#--LEAVE COMMENTED
		# check this file's format

		#if ($fields->param("format") eq "*all*")		
		#	{CheckCategory();}
		#elsif ($fields->param("format") eq "CD"  &&  ($file =~ /cd-/  ||  $file =~ /cdcomp-/))
		#	{CheckCategory();}
		#elsif ($fields->param("format") eq "LP"  &&  ($file !~ /cd-/  &&  $file !~ /cdcomp-/))
		#	{CheckCategory();}
		#--END LEAVE COMMENTED
		}
	}
closedir(DIR);

$results = '';
foreach $sfile (sort(@searchFiles))
	{SearchFile();}

print "<span style=\"font-size: 18px;\">";
if ($totalhits == 1)
	{print $totalhits . " result:";}
if ($totalhits > 1)
	{print $totalhits . " results:";}
print "</span><br /><br />\n";

print $results;
&PrintFtr;

exit;







########################
# SUBROUTINES
########################


#################################
sub CheckCategory
{
	# check this file's category

	if ($fields->param("files") eq "*all*")		
		{push @searchFiles, $file;}

	else
		{
		# we have to match the selected categories
		foreach $cat (@cats)
			{
			# if the filename starts with one of the categories we want, then use it
			$cat = lc($cat);
			if ($file =~ /^$cat/)
				{
				push @searchFiles, $file;
				last;
				}
			}
		}
}



#################################
sub SearchFile
{
# open the file
if (! open (LIST, "filz/$sfile"))
	{
	print "$sfile - Could not display requested records - please try again later.";
	exit;
	}

# loop through file & print each record in the table

local($line,$value);
$num = 0;
$bingo = 0;
$xx;
while (<LIST>)
	{
	$num++;
	chop;
	$line = uc($_);
	# skip the first 3 fields (new, category, date added)
	($undef, $undef, $undef, $line) = split('\t', $line, 4);

	if ($num == 1)
		{
		# save heading for later
		$head = "ADD\t" . $line;
		$head =~ s|\t|</span></b></td>\n<td style=\"text-align: center;\"><b><span style="font-size: 12px; color: #CC0066;">|g;
		$head = "<tr>\n<td style=\"text-align: center; width: 10%\"><b><span style=\"font-size: 12px; color: #CC0066;\">$head</span></b></td>\n</tr>\n";
		next;
		}

	if (length($line) < 2)	# skip blank lines
		{next;}

	# see if this line has the search term in it

	# loop thru each search term
	foreach $xxx (@searches)
		{
		# if we're not doing an exact match search, then split on the spaces
		if ($exactMatch eq "EXACT")
			{@terms = $xxx;}
		else	
			{@terms = split(/ /, $xxx);}

		$numTerms=0;
		$numTermHits=0;
		foreach $xx (@terms)
			{
			$numTerms++;
			# if there's a "." in the term, replace it with "\."
			$xx =~ s/\./\\\./g;
			if ($line =~ /$xx/)
				{
				# this is a match, but see if there are any exclusions
				if ($exclude ne '')
					{
					# loop thru each exclusion
					foreach $excl (@exclusions)
						{
						# if there's a "." in the term, replace it with "\."
						$excl =~ s/\./\\\./g;
						if ($line =~ /$excl/)
							{$numTermHits = -99;}
						}
					if ($numTermHits >= 0)	# no exclusions were found
						{$numTermHits++;}
					}
				else
					{$numTermHits++;}
				}
			}


		# we need to match all terms for this to be a hit
		if ($numTermHits == $numTerms)
			{
			$bingo++;
			$totalhits++;
			$file2 = $sfile;
			$file2 =~ s/\.vvm//;
			if ($bingo == 1)
				{
				# this is our first record from this file
				# start the table
				$results = $results . "<table cellspacing=\"1\" cellpadding=\"4\" border=\"2\"><tr><td colspan=\"3\">$file2</td><td colspan=\"3\">&nbsp;</td></tr>\n$head";
				}

			$valueline = $line;
			# make each search term blue
			foreach $xx (@terms)
				{
				# when printing the term in blue, take out the backslash
				$yy = $xx;
				$yy =~ s/\\\+/+/g;
				# if there's a "\." in the term, replace it with "."
				$yy =~ s/\\\./\./g;
				$line =~ s|$xx|<span style="color: blue">$yy</span>|g;
				}

			# add category to beginning of line
			$value = "$sfile~~$valueline";
			$value =~ s|\t|~~|g;
			$value =~ s/\"/\'/g;
			$line =~ s|\t|</span></b></td>\n<td><b><span style="font-size: 12px;">|g;

			$results = $results . "<tr>\n<td style=\"text-align: center; width: 10%\">\n<input type=\"checkbox\" name=\"box$totalhits\" value=\"$value\"></td><td><b><span style=\"font-size: 12px;\">$line</font></b></td>\n</tr>\n";
			last;
			}
		}
	}

if ($bingo > 0)
	{$results = $results . "</table>";}

close LIST;
}




#################################
sub PrintHdr
{
print <<ENDHEADER;
<!DOCTYPE html>
<html>
<head>
<title>VVMO Catalog Search Results</title>

<style type="text/css">
body { background: #ff99cc url(/back.gif); color: #000; font-size: 16px; }
a { color: #8000FF; }
a:hover { color: #f00; }
a:visited { color: #c06; }
img { border: 0; }
#wrapper { text-align: center; }
table { width: 75%; margin: 0px auto; }
table td { text-align: left; }
</style>

</head>

<body>
<div id="wrapper">
	<img src="/vvmo.gif" width="268" height="95" style="margin: 8px 4px" alt="VVMO"><br /><br />

	<span style="font-size: 24px"><b>Catalog Search Results</b></span>

	<p>
	$COND_STATEMENT
	</p>
	
	<p>
		<b><em>$INSTRUCTIONS</em></b>
	</p>
	
	<form method="post" action="/cgi-bin/shopcart.pl">
ENDHEADER
}






########################

sub PrintFtr
{
if ($totalhits == 0)
	{print "<hr /><span style=\"font-size: 18px;\"><p>Sorry, there are no matches for your search.<br />Please check that you have entered the phrase correctly and according to search engine instructions.</p><p>If you are still having difficulties finding what you are looking for, please feel free to contact us at<BR><a href=\"mailto:help\@vvmo.com\">help\@vvmo.com</a> or call us at (847) 328-2899.</p><p><hr /></p><p><<br /></p>";}
else
	{print "<p><span style=\"font-size: 16px;\"><a href=\"#top\">Back to Top</a></span></p>\n<p>\n<input type=\"submit\" value=\"Add to Cart/Checkout\"></p>";}

print <<ENDFOOTER;
</form>

<p>
<span style="font-size: 16px;">
| 
<a href="/welcome.html"><b>Home</b></a> | 
<a href="/search.html"><b>Search</b></a> |
<a href="/cgi-bin/catalog.pl?recarr"><b>Recent Arrivals</b></a> | 
<a href="/catalog.html"><b>Catalog</b></a> | 
<a href="/about-us.html"><b>About Us</b></a> | 
<a href="/helpful-hints.html"><b>Helpful Hints</b></a> | 
<a href="/links.html"><b>Links</b></a> | 
</span>
</p>
</div>

<p>
<table>
<tr><td align="right"><span style="font-size: 12px">$totalhits</span></td></tr>
</table>
</p>

</body>
</html>
ENDFOOTER
}


